/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Ruins
**
** DESCRIPTION:	Ruins puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef RUINS_H
#define RUINS_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "Puzzle.h"
#include "../Collectables/CollectableInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Ruins_c_iMaxRubblePieces = 10;
const ldwPoint Ruins_c_sScaffoldingPos[2] = {
	ldwPoint(1240, 1880),
	ldwPoint(1270, 1830)
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CRuins : public IPuzzle, public ICollectable
{
	friend class CPuzzle;

private:

	//class enumerations
	enum ERef
	{
		eRef_Rubble = ePuzzle_Ruins + (1 << 16),
		eRef_Scaffolding1 = ePuzzle_Ruins + (2 << 16),
		eRef_Scaffolding2 = ePuzzle_Ruins + (3 << 16)
	};

	//class structures
	struct SSaveState
	{
	};

	//class data
	ldwImageGrid *	m_pRubble;
	ldwImage *		m_pScaffolding;

	//class methods
	//setup
	public:		CRuins(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Refresh();
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Complete();

	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying);
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying);

	// access
	public:		const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos);
	public:		const bool AreUncovered() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CRuins		Ruins;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/